/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.BuilderTMoc;
import cds.allsky.Context;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Util;
import java.io.File;

public class BuilderSTMoc
extends BuilderTMoc {
    STMoc stmoc;
    private int nbAdd = 0;

    public BuilderSTMoc(Context context) {
        super(context);
    }

    @Override
    protected void reduction(Moc m) throws Exception {
        if (this.ruleSize == null) {
            this.ruleSize = "tts";
        }
        while (m.getMem() > this.maxSize && (m.getTimeOrder() > 0 || m.getSpaceOrder() > 0)) {
            char c = this.ruleSize.charAt(0);
            if (c != 't' && c != 's') {
                throw new Exception("Unknown MOC degration rule character [" + c + "]");
            }
            if (c == 't' && m.getTimeOrder() > 0) {
                m.setTimeOrder(m.getTimeOrder() - 1);
            } else {
                if (c != 's' || m.getSpaceOrder() <= 0) break;
                m.setSpaceOrder(m.getSpaceOrder() - 1);
            }
            this.ruleSize = this.ruleSize.substring(1) + c + "";
        }
    }

    @Override
    protected void initIt() throws Exception {
        this.stmoc = new STMoc(this.timeOrder, this.spaceOrder);
    }

    @Override
    protected void info() {
        String s = this.maxSize <= 0L ? "" : " sizeLimit<" + Util.getUnitDisk(this.maxSize) + (this.ruleSize != null ? "(degradationRule:" + this.ruleSize + ")" : "");
        String s1 = this.stmoc.getMem() > 0L ? " currentSize=" + Util.getUnitDisk(this.stmoc.getMem()) : "";
        this.context.info("STMOC generation (timeOrder=" + this.stmoc.getTimeOrder() + " spaceOrder=" + this.stmoc.getSpaceOrder() + s + s1 + ")...");
    }

    @Override
    protected boolean mustAdjustSize(Moc m, boolean force) {
        if (force) {
            return true;
        }
        if (this.nbAdd < 1000) {
            ++this.nbAdd;
            return false;
        }
        this.nbAdd = 0;
        return true;
    }

    @Override
    protected void addIt(TMoc tmoc1, SMoc smoc1) throws Exception {
        double jdtmin = tmoc1.getTimeMin();
        double jdtmax = tmoc1.getTimeMax();
        this.stmoc.add(jdtmin, jdtmax, smoc1);
        this.adjustSize(this.stmoc, false);
    }

    @Override
    protected void cleanIt() throws Exception {
        String file = this.context.getOutputPath() + Util.FS + "STMoc.fits";
        new File(file).delete();
    }

    @Override
    protected void writeIt() throws Exception {
        this.adjustSize(this.stmoc, true);
        this.stmoc.seeRangeList().checkConsistency();
        if (this.stmoc.isEmpty()) {
            throw new Exception("Empty MOC => not generated");
        }
        String file = this.context.getOutputPath() + Util.FS + "STMoc.fits";
        this.stmoc.write(file);
    }
}

